# need to install tinytag, requests
# CMD Parameters:
# --path <path to folder>
# --debug

from tkinter import filedialog
from tkinter import *
from tkinter import ttk
from tinytag import TinyTag
import threading, requests, json, sys, os

print(">> Bulk .LRC downloader\n Lyrics downloader for music files")

debug = False
def dbg(txtx):
    if debug == True:
        print("[DEBUG]",txtx)
fn = False
nxdr = False
for i in range(1, len(sys.argv)):
    if nxdr == True:
        fn = sys.argv[i]
        nxdr = False
    if sys.argv[i] == "--path":
        if i != len(sys.argv):
            nxdr = True
        else:
            raise Exception("--path parameter used but no directory specified")
    if sys.argv[i] == "--debug":
        debug = True
if fn == False:
    fn = filedialog.askdirectory()
fp = fn+"/"
files = sorted(os.listdir(fp))
for v in files:
    dbg(v)
    if (not ".mp3" in v and not ".m4a" in v and not ".wav" in v) or ".lrc" in v:
        files.remove(v)
        dbg(" - remove\n")
dbg(files)

window = Tk()
window.title("Bulk .LRC downloader")
window.geometry("670x295")
window.resizable(False,False)
window.iconbitmap("bitmap.ico")

theme = ttk.Style(window)
theme.theme_use("alt")

pg = IntVar()
pg.set(0)
pb = ttk.Progressbar(window, variable=pg, maximum=len(files))
pb.place(x=5, y=270, width=660)
maxxlf = len(files)

l = Listbox(window)
l.place(x=450, y=20, height=190, width=215)
for i in range(0, len(files)-1):
    if (not ".mp3" in files[i] and not ".m4a" in files[i] and not ".wav" in files[i]) or ".lrc" in files[i]:
        files.remove(files[i])
    l.insert(i, files[i])
lb1 = Label(window, text="Remaining files")
lb1.place(x=450, y=0, height=19)

ttl = StringVar()
ttl.set("Loading..")
ar = StringVar()
ar.set("")

title = Label(window, text="..", textvariable=ttl, font=("", 25, "bold"))
title.place(x=5,y=215)
title2 = Label(window, text="..", textvariable=ar, font=("", 10))
title2.place(x=5,y=200)


hdrs = {'Accept-Encoding': 'gzip, deflate'}
ssn = requests.Session()
def geta(urll):
    dbg(urll)
    r = ssn.get(urll, headers=hdrs)
    if r.status_code == 200:
        return r.json()
    else:
        return False

def srcex(sf):
    ab = sf.album
    if not sf.album:
        ab = sf.title
    deeta = geta("https://lrclib.net/api/get?artist_name="+sf.artist+"&track_name="+sf.title+"&album_name="+ab+"&duration="+str(sf.duration-1.5))
    if deeta != False and id(deeta["syncedLyrics"])!=id(None):
        return deeta
    deeta = geta("https://lrclib.net/api/get?artist_name="+sf.artist+"&track_name="+sf.title+"&album_name="+ab+"&duration="+str(sf.duration+1.5))
    if deeta != False and id(deeta["syncedLyrics"])!=id(None):
        return deeta
    return False

def upd():
    for i in range(0,len(files)-1):
        l.delete(0)
        pg.set(i+1)
        try:
            f = TinyTag.get(fp+"/"+files[i])
            ttl.set(f.title)
            ar.set(f.artist)
            srcexx = srcex(f)
            if srcexx != False:
                w = open(fp+os.path.splitext(files[i])[0]+".lrc", "w", encoding="utf-8")
                dbg(fp+os.path.splitext(files[i])[0]+".lrc")
                dbg("[ti:"+f.title+"]\n[ar:"+f.artist+"]\n[al:"+f.album+"]\n"+srcexx["syncedLyrics"])
                w.write("[ti:"+f.title+"]\n[ar:"+f.artist+"]\n[al:"+f.album+"]\n"+srcexx["syncedLyrics"])
                w.close()
        except (TypeError,RuntimeError):
            dbg("skill issue")
    ttl.set("Done!")
    print("Finished!")
    pg.set(maxxlf)
    ar.set("")
    for i in range(0, maxxlf):
        l.delete(0)
thrd = threading.Thread(target=upd, args=())
thrd.daemon = True
thrd.start()
window.mainloop()
