import { Client, GatewayIntentBits } from 'discord.js';
import dotenv from 'dotenv';
import { Ollama } from 'ollama';

dotenv.config();

const ollama = new Ollama({ host: 'http://127.0.0.1:11434' });
const client = new Client({
  intents: [
    GatewayIntentBits.Guilds,
    GatewayIntentBits.GuildMessages,
    GatewayIntentBits.MessageContent,
  ],
});

const channelMemories = new Map();

client.on('ready', () => {
  console.log(`Logged in as ${client.user.tag}!`);
});

client.on('messageCreate', async (message) => {
  if (message.author.bot) return;

  const mentionedBot = message.mentions.has(client.user.id);
  const isReplyToBot = await checkReplyToBot(message);

  if (mentionedBot || isReplyToBot) {
    try {
      const channelId = message.channel.id;
      const userInput = cleanInput(message.content, client.user.id);
      
      const memory = channelMemories.get(channelId) || {
        messages: [],
        context: [],
      };

      memory.messages.push({ role: 'user', content: userInput });
      
      const botMessage = await message.reply("[Generating...](https://alexv.netlify.app/cdn/loadinginfinite.gif)");
      await message.channel.sendTyping();

      let fullResponse = '';
      let lastUpdate = Date.now();
      
      const stream = await ollama.generate({
        model: 'llama3.2',
        prompt: buildPrompt(memory.messages).trim(),
        context: memory.context,
        stream: true,
      });

      for await (const chunk of stream) {
        fullResponse += chunk.response;
        memory.context = chunk.context;
        
        if (Date.now() - lastUpdate > 500) {
          await updateMessage(botMessage, fullResponse.trim());
          lastUpdate = Date.now();
          await message.channel.sendTyping();
        }
      }

      await updateMessage(botMessage, fullResponse.trim());
      
      memory.messages.push({ role: 'assistant', content: fullResponse });
      trimMemory(memory);
      channelMemories.set(channelId, memory);

    } catch (error) {
      console.error('Error:', error);
      message.reply('❌ Error processing request').catch(console.error);
    }
  }
});

async function checkReplyToBot(message) {
  if (!message.reference) return false;
  try {
    const repliedMessage = await message.channel.messages.fetch(message.reference.messageId);
    return repliedMessage.author.id === client.user.id;
  } catch (error) {
    return false;
  }
}

function cleanInput(text, botId) {
  return text.replace(`<@${botId}>`, '').trim();
}

function buildPrompt(messages) {
  return messages.map(m => `${m.role === 'user' ? 'User' : 'Assistant'}: ${m.content}`).join('\n');
}

async function updateMessage(message, content) {
  try {
    await message.edit(content.slice(0, 2000));
  } catch (error) {
    console.error('Error editing message:', error);
  }
}

function trimMemory(memory, maxHistory = 10) {
  if (memory.messages.length > maxHistory * 2) {
    memory.messages = memory.messages.slice(-maxHistory * 2);
  }
}

client.login("MTMzMjI0OTExNTUzNDI5NTEwMQ.GI7R0X.drPyndsQ9FzzkbgkG84Zspp_pnXzPeqh_ehszQ");